from EnumDefinitions import *

def AnalysisConfiguration(solutiontype):
	"""
	ANALYSISCONFIGURATION - return type of analyses, number of analyses 

	   Usage:
	      [analyses, numanalyses]=AnalysisConfiguration(solutiontype);
	"""

	if   solutiontype == DiagnosticSolutionEnum:
		numanalyses=5
		analyses=[DiagnosticHorizAnalysisEnum,DiagnosticVertAnalysisEnum,DiagnosticHutterAnalysisEnum,SurfaceSlopeAnalysisEnum,BedSlopeAnalysisEnum]

	elif solutiontype == SteadystateSolutionEnum:
		numanalyses=7 
		analyses=[DiagnosticHorizAnalysisEnum,DiagnosticVertAnalysisEnum,DiagnosticHutterAnalysisEnum,SurfaceSlopeAnalysisEnum,BedSlopeAnalysisEnum,ThermalAnalysisEnum,MeltingAnalysisEnum]

	elif solutiontype == ThermalSolutionEnum:
		numanalyses=2 
		analyses=[ThermalAnalysisEnum,MeltingAnalysisEnum]

	elif solutiontype == EnthalpySolutionEnum:
		numanalyses=1 
		analyses=[EnthalpyAnalysisEnum]

	elif solutiontype == PrognosticSolutionEnum:
		numanalyses=1 
		analyses=[PrognosticAnalysisEnum]

	elif solutiontype == BalancethicknessSolutionEnum:
		numanalyses=1 
		analyses=[BalancethicknessAnalysisEnum]

	elif solutiontype == SurfaceSlopeSolutionEnum:
		numanalyses=1 
		analyses=[SurfaceSlopeAnalysisEnum]

	elif solutiontype == BedSlopeSolutionEnum:
		numanalyses=1 
		analyses=[BedSlopeAnalysisEnum]

	elif solutiontype == TransientSolutionEnum:
		numanalyses=9 
		analyses=[DiagnosticHorizAnalysisEnum,DiagnosticVertAnalysisEnum,DiagnosticHutterAnalysisEnum,SurfaceSlopeAnalysisEnum,BedSlopeAnalysisEnum,ThermalAnalysisEnum,MeltingAnalysisEnum,EnthalpyAnalysisEnum,PrognosticAnalysisEnum]

	elif solutiontype == FlaimSolutionEnum:
		numanalyses=1 
		analyses=[FlaimAnalysisEnum]

	elif solutiontype == HydrologySolutionEnum:
		numanalyses=3 
		analyses=[BedSlopeAnalysisEnum,SurfaceSlopeAnalysisEnum,HydrologyAnalysisEnum]

	else:
		raise TypeError("solution type: '%s' not supported yet!" % EnumToString(solutiontype))

	return analyses,numanalyses

