/*!\file Solverx
 * \brief solver
 */

#include "./Solverx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

void	Solverx(Vector** puf, Matrix* Kff, Vector* pf, Vector* uf0,Vector* df, Parameters* parameters){

	/*Intermediary: */
	int analysis_type;

	/*output: */
	Vector *uf=NULL;

	/*In debugging mode, check that stiffness matrix and load vectors are not NULL (they can be empty)*/
	_assert_(Kff);
	_assert_(pf);

	/*Initialize vector: */
	uf=new Vector();

	/*According to matrix type, use specific solvers: */
	switch(Kff->type){
		#ifdef _HAVE_PETSC_
		case PetscMatType:{
			PetscVec* uf0_vector = NULL;
			PetscVec* df_vector  = NULL;
			if(uf0) uf0_vector = uf0->pvector;
			if(df)  df_vector  = df->pvector;
			SolverxPetsc(&uf->pvector,Kff->pmatrix,pf->pvector,uf0_vector,df_vector,parameters);
			break;}
		#endif
		case SeqMatType:{
			SolverxSeq(&uf->svector,Kff->smatrix,pf->svector);
			break;}
		default:
			  _error2_("Matrix type: " << Kff->type << " not supported yet!");
	}

	/*Assign output pointers: */
	*puf=uf;
}
