/*!\file SystemMatricesx
 * \brief: create system matrices (stiffness matrix, loads vector)
 */

#include "./SystemMatricesx.h"

#undef __FUNCT__ 
#define __FUNCT__ "SystemMatricesx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void SystemMatricesx(Mat* pKgg, Vec* ppg,DataSet* elements,DataSet* nodes,DataSet* loads,DataSet* materials,
		int kflag,int pflag,int connectivity,int numberofdofspernode,ParameterInputs* inputs,int analysis_type){
	
	int i;

	extern int num_procs;
	extern int my_rank;
	
	/*intermediary: */
	int gsize;

	/*output: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);
	loads->Configure(elements, loads, nodes, materials);

	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs();

	/*Allocate Kgg and pg: */
	if(kflag)Kgg=NewMat(gsize,gsize,NULL,&connectivity,&numberofdofspernode);
	if(pflag)pg=NewVec(gsize);

	/*Fill stiffness matrix and right hand side vector, from elements: */
	if(kflag)elements->CreateKMatrix(Kgg,inputs,analysis_type);
	if(pflag)elements->CreatePVector(pg,inputs,analysis_type);
	
	/*Fill stiffness matrix and right hand side vector, from loads: */
	if(kflag)loads->CreateKMatrix(Kgg,inputs,analysis_type);
	if(pflag)loads->CreatePVector(pg,inputs,analysis_type);

	/*Assemble matrices: */
	if(kflag){
		MatAssemblyBegin(Kgg,MAT_FINAL_ASSEMBLY);
		MatAssemblyEnd(Kgg,MAT_FINAL_ASSEMBLY);
		MatCompress(Kgg);
	}
	if(pflag){
		VecAssemblyBegin(pg);
		VecAssemblyEnd(pg);
	}
	
	/*Assign output pointers: */
	*pKgg=Kgg;
	*ppg=pg;
}
