def addnote(md,string):
	"""
	ADDNOTE - add a note to the existing model notes field
	 
	    Usage:
	       md=addnote(md,string);
	 
	    Example:
	       md=addnote(md,'Pine Island, Geometry of 2007');
	"""

	if not isinstance(string,str):
		raise TypeError('addnote error message: second input argument should be a string')

	notes=md.miscellaneous.notes

	if isinstance(notes,str):
		newnotes=[notes,string]
	else:
		newnotes=notes.append(string)

	md.miscellaneous.notes=newnotes

	return md

