/* \file objects.h
 * \brief: prototype header for all objects.
 */

#ifndef ALL_OBJECTS_H_
#define ALL_OBJECTS_H_

/*Abstract classes: */
#include "./objects/objects.h"

/*Objects: */
#include "./Hook.h"
#include "./DofIndexing.h"
#include "./IoModel.h"
#include "./Patch.h"
#include "./Update.h"

/*Gauss*/
#include "./gauss/GaussTria.h"
#include "./gauss/GaussPenta.h"

/*Numerics:*/
#include "./matrix/ElementMatrix.h"
#include "./matrix/ElementVector.h"
#include "./matrix/Vector.h"
#include "./matrix/Matrix.h"

/*C objects: */
#include "./FemModel.h"
#include "./OptArgs.h"
#include "./OptPars.h"

/*Bamg: */
#include "./bamg/BamgOpts.h"
#include "./bamg/BamgGeom.h"
#include "./bamg/BamgMesh.h"
#include "./bamg/Metric.h"
#include "./bamg/DoubleAndInt.h"
#include "./bamg/Direction.h"
#include "./bamg/BamgVertex.h"
#include "./bamg/AdjacentTriangle.h"
#include "./bamg/Edge.h"
#include "./bamg/GeomVertex.h"
#include "./bamg/GeomEdge.h"
#include "./bamg/Curve.h"
#include "./bamg/Triangle.h"
#include "./bamg/ListofIntersectionTriangles.h"
#include "./bamg/GeomSubDomain.h"
#include "./bamg/SubDomain.h"
#include "./bamg/VertexOnGeom.h"
#include "./bamg/VertexOnVertex.h"
#include "./bamg/VertexOnEdge.h"
#include "./bamg/CrackedEdge.h"
#include "./bamg/Mesh.h"
#include "./bamg/Geometry.h"
#include "./bamg/BamgQuadtree.h"
#include "./bamg/SetOfE4.h"

/*Kriging*/
#include "./kriging/Variogram.h"
#include "./kriging/GaussianVariogram.h"
#include "./kriging/ExponentialVariogram.h"
#include "./kriging/SphericalVariogram.h"
#include "./kriging/PowerVariogram.h"
#include "./kriging/Quadtree.h"
#include "./kriging/Observation.h"

#endif
