/*
 * CreateNodesDiagnosticHutter.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHutter(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;
	int    numberofvertices;
	bool   ishutter;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);
	iomodel->Constant(&ishutter,FlowequationIshutterEnum);

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes();

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if(!ishutter){
		*pnodes=nodes;
		return;
	}

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*First fetch data: */
	iomodel->FetchData(7,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MeshElementsEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);

	for (i=0;i<numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHutterAnalysisEnum));

		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(7,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MeshElementsEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
