/*!\file:  AddExternalResultx.cpp
 * \brief: go through our finite elements, and see what results they have stored within. 
 * Then output them into serialized patch arrays, and dump to disk.
 */ 

#include "./AddExternalResultx.h"
#include "../../Container/Container.h"
#include "../../io/io.h"
#include "../../classes/objects/objects.h"
		
void AddExternalResultx( DataSet* results, int enumtype, double value){
	/* Add new result in into results*/
	results->AddObject(new DoubleExternalResult(results->Size()+1,enumtype,value,1,0));
}
void AddExternalResultx( DataSet* results, int enumtype, double* value, int nraws){
	/* Add new result in into results*/
	results->AddObject(new DoubleVecExternalResult(results->Size()+1,enumtype,value,nraws,1,0));
}
