/*!\file OptionLogical.cpp
 * \brief: implementation of the optionslogical object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/shared.h"
#include "../../../io/io.h"
#include "../../../Container/Container.h"
#include "../../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionLogical::OptionLogical(){{{*/
OptionLogical::OptionLogical(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionLogical::~OptionLogical(){{{*/
OptionLogical::~OptionLogical(){

	if (values) xDelete<bool>(values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionLogical::Echo {{{*/
void  OptionLogical::Echo(){

	char  cstr[81];
	bool  flag=true;

	if(flag) _pprintLine_("OptionLogical Echo:");
	Option::Echo();

	if (values && size) {
		if(numel == 1) if(flag) _pprintLine_("        values: " << (values[0] ? "true" : "false"));
		else{
			StringFromSize(cstr,size,ndims);
			if(flag) _pprintLine_("        values: " << cstr << " " << "logical");
		}
	}
	else if(flag) _pprintLine_("        values: [empty]");
}
/*}}}*/
/*FUNCTION OptionLogical::DeepEcho() {{{*/
void  OptionLogical::DeepEcho(){

	char  indent[81]="";

	OptionLogical::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionLogical::DeepEcho(char* indent) {{{*/
void  OptionLogical::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	if(flag) _pprintLine_(indent << "OptionLogical DeepEcho:");
	Option::DeepEcho(indent);

	xMemCpy<char>(indent2,indent,(strlen(indent)+1));
	strcat(indent2,"  ");

	if (values) {
		if(numel==1) if(flag) _pprintLine_(indent << "        values: " << (values[0] ? "true" : "false"));
		else{
			dims=xNew<int>(ndims);
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				if(flag) _pprintLine_(indent << "        values" << cstr << ": " << (values[i] ? "true" : "false"));
			}
			xDelete<int>(dims);
		}
	}
	else if(flag) _pprintLine_(indent << "        values: [empty]");
}
/*}}}*/
/*FUNCTION OptionLogical::Name {{{*/
char* OptionLogical::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionLogical::NumEl {{{*/
int   OptionLogical::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionLogical::NDims {{{*/
int   OptionLogical::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionLogical::Size {{{*/
int*  OptionLogical::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionLogical::Get(bool* pvalue) {{{*/
void OptionLogical::Get(bool* pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error2_("option \"" << this->name << "\" has " << this->NumEl() << " elements and cannot return a single bool");
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
