/*! \file OptionCell.h 
 *  \brief: header file for optioncell object
 */

#ifndef _OPTIONCELL_H_
#define _OPTIONCELL_H_

/*Headers:{{{*/
#include "../../../include/include.h"
#include "../../../shared/Exceptions/exceptions.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionCell: public Option {

	public:

		Options* values;

		/*OptionCell constructors, destructors {{{*/
		OptionCell();
		~OptionCell();
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error2_("Not implemented yet");};
		int   MyRank(){_error2_("Not implemented yet");};
		int   ObjectEnum(){return OptionCellEnum;};
		Object* copy(){_error2_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue){_error2_("An OptionCell object cannot return a int");};
		void  Get(IssmDouble* pvalue){_error2_("An OptionCell object cannot return a IssmDouble");};
		void  Get(bool* pvalue){  _error2_("An OptionCell object cannot return a bool");};
		void  Get(char** pvalue){ _error2_("An OptionCell object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error2_("An OptionCell object cannot return a string vec");};
		void  Get(IssmDouble** pvalue,int *pnumel){ _error2_("An OptionCell object cannot return a IssmDouble vec");};
		void  Get(Options** pvalue);
		void  Get(Options*** ppvalue,int *pnumel){ _error2_("An OptionCell object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONCELL_H */

