/*!\file Option.cpp
 * \brief: implementation of the optionsobject abstract object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
#include "../../../io/io.h"
#include "../../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION Option::Option(){{{*/
Option::Option(){

	name  =NULL;
	numel =0;
	ndims =0;
	size  =NULL;

}
/*}}}*/
/*FUNCTION Option::~Option(){{{*/
Option::~Option(){

	if(size) xDelete<int>(size);
	if(name) xDelete<char>(name);

}
/*}}}*/

/*Other*/
/*FUNCTION Option::Echo {{{*/
void  Option::Echo(){

	char  cstr[81];
	bool  flag=true;

	if(flag) _pprintLine_("          name: \"" << name << "\"");
	if(flag) _pprintLine_("         numel: " << numel);
	if(flag) _pprintLine_("         ndims: " << ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		if(flag) _pprintLine_("          size: " << cstr);
	}
	else if(flag) _pprintLine_("          size: [empty]");
}
/*}}}*/
/*FUNCTION Option::DeepEcho() {{{*/
void  Option::DeepEcho(){

	char  indent[81]="";

	Option::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION Option::DeepEcho(char* indent) {{{*/
void  Option::DeepEcho(char* indent){

	char  cstr[81];
	bool  flag=true;

	if(flag) _pprintLine_(indent << "          name: \"" << name << "\"");
	if(flag) _pprintLine_(indent << "         numel: " << numel);
	if(flag) _pprintLine_(indent << "         ndims: " << ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		if(flag) _pprintLine_(indent << "          size: " << cstr);
	}
	else if(flag) _pprintLine_(indent << "          size: [empty]");
}
/*}}}*/
/*FUNCTION Option::Name {{{*/
char* Option::Name(){

	return(name);
}
/*}}}*/
/*FUNCTION Option::NumEl {{{*/
int   Option::NumEl(){

	return(numel);
}
/*}}}*/
/*FUNCTION Option::NDims {{{*/
int   Option::NDims(){

	return(ndims);
}
/*}}}*/
/*FUNCTION Option::Size {{{*/
int*  Option::Size(){

	return(size);
}
/*}}}*/
/*FUNCTION Option::Get {{{*/
//void* Option::Get(){

//	;

//	return;
//}
/*}}}*/
