/*!\file:  Load.h
 * \brief abstract class for Load object
 * This class is a place holder for the Icefront  and the Penpair loads.
 * It is derived from Load, so DataSets can contain them.
 */ 


#ifndef _LOAD_H_
#define _LOAD_H_

/*Headers:*/
/*{{{*/
class Object;
class Matrix;
class Vector;

#include "../Object.h"
#include "../../../toolkits/toolkits.h"
#include "../../../Container/Container.h"
/*}}}*/

class Load: public Object,public Update{

	public: 

		virtual       ~Load(){};
		
		/*Virtual functions: {{{*/
		virtual void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void  CreateKMatrix(Matrix* Kff, Matrix* Kfs)=0;
		virtual void  CreatePVector(Vector* pf)=0;
		virtual void  CreateJacobianMatrix(Matrix* Jff)=0;
		virtual void  PenaltyCreateJacobianMatrix(Matrix* Jff,IssmDouble kmax)=0;
		virtual void  PenaltyCreateKMatrix(Matrix* Kff, Matrix* Kfs, IssmDouble kmax)=0;
		virtual void  PenaltyCreatePVector(Vector* pf, IssmDouble kmax)=0;
		virtual bool  InAnalysis(int analysis_type)=0;
		/*}}}*/
};
#endif
