/*! \file BoolExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLEXTERNALRESULT_H_
#define _BOOLEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../../include/include.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../../include/include.h"
/*}}}*/

class BoolExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		bool   value;
		int    step;
		IssmDouble time;

		/*BoolExternalResult constructors, destructors: {{{*/
		BoolExternalResult();
		BoolExternalResult(int id, int enum_type,bool value,int step,IssmDouble time);
		~BoolExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif
