/*! \file PentaP1ElementResult.h 
 *  \brief: header file for PentaP1ElementResult object
 *  this object is just a PentaP1Input with additional time and step info.
 */


#ifndef _PENTAP1ELEMENTRESULT_H_
#define _PENTAP1ELEMENTRESULT_H_

/*Headers:*/
/*{{{*/
#include "../Inputs/Input.h"
#include "../../../include/include.h"
/*}}}*/

class PentaP1ElementResult: public ElementResult{

	private: 
		int    enum_type;
		IssmDouble values[6];
		int    step;
		IssmDouble time;

	public:

		/*PentaP1ElementResult constructors, destructors: {{{*/
		PentaP1ElementResult();
		PentaP1ElementResult(int enum_type,IssmDouble* values,int step, IssmDouble time);
		~PentaP1ElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{*/
		ElementResult* SpawnTriaElementResult(int* indices);
		IssmDouble  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*PentaP1ElementResult management: {{{*/
		int   InstanceEnum();
		void GetVectorFromResults(Vector* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector* vector,int dof);
		/*}}}*/

};
#endif  /* _PENTAP1ELEMENTRESULT_H */
