/*!\file Contour.h
 * \brief: header file for Contour object
 */

#ifndef _CONTOUR_H_
#define _CONTOUR_H_

/*Headers:*/
/*{{{*/
#include "./Object.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../toolkits/toolkits.h"
#include "../../include/include.h"
/*}}}*/

class Contour: public Object{

	public: 

		int     id;
		int	  nods;  //number of vertices in the contour
		IssmDouble* x;
		IssmDouble* y;
		bool    closed; //is this contour closed?

		/*Contour constructors, destructors {{{*/
		Contour();
		Contour(int id, int nods, IssmDouble* x, IssmDouble* y,bool closed);
		~Contour();
		/*}}}*/
		/*Object virtual functions{{{*/
		void  Echo(void);
		void  DeepEcho(void);
		int   Id(void);
		int   MyRank(void);
		int   ObjectEnum(void);
		Object* copy(void);
		/*}}}*/


};

#endif  /* _CONTOUR_H_ */
