/*!\file IntVecParam.c
 * \brief: implementation of the IntVecParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntVecParam constructors and destructor*/
/*FUNCTION IntVecParam::IntVecParam(){{{*/
IntVecParam::IntVecParam(){
	return;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,int* values,int M){{{*/
IntVecParam::IntVecParam(int in_enum_type,int* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=xNew<int>(M);
		xMemCpy<int>(values,in_values,M);
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,IssmDouble* values,int M){{{*/
IntVecParam::IntVecParam(int in_enum_type,IssmDouble* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=xNew<int>(M);
		for(int i=0;i<in_M;i++) values[i]=reCast<int>(in_values[i]);
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::~IntVecParam(){{{*/
IntVecParam::~IntVecParam(){
	xDelete<int>(values);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntVecParam::Echo {{{*/
void IntVecParam::Echo(void){

	_printLine_("IntVecParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   vector size: " << this->M);

}
/*}}}*/
/*FUNCTION IntVecParam::DeepEcho{{{*/
void IntVecParam::DeepEcho(void){

	int i;
	
	_printLine_("IntVecParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   vector size: " << this->M);
	for(i=0;i<this->M;i++){
		_printLine_(i << " " << this->values[i]);
	}
}
/*}}}*/
/*FUNCTION IntVecParam::Id{{{*/
int    IntVecParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntVecParam::MyRank{{{*/
int    IntVecParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntVecParam::ObjectEnum{{{*/
int IntVecParam::ObjectEnum(void){

	return IntVecParamEnum;

}
/*}}}*/
/*FUNCTION IntVecParam::copy{{{*/
Object* IntVecParam::copy() {
	
	return new IntVecParam(this->enum_type,this->values,this->M);

}
/*}}}*/

/*IntVecParam virtual functions definitions: */
/*FUNCTION IntVecParam::GetParameterValue{{{*/
void  IntVecParam::GetParameterValue(int** pintarray,int* pM){
	int* output=NULL;

	if(M){
		output=xNew<int>(M);
		xMemCpy<int>(output,values,M);
	}

	/*Assign output pointers:*/
	if(pM) *pM=M;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntVecParam::GetParameterName{{{*/
void IntVecParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntVecParam::SetValue{{{*/
void  IntVecParam::SetValue(int* intarray,int in_M){

	/*avoid leak: */
	xDelete<int>(this->values);

	if(in_M){
		this->values=xNew<int>(in_M);
		xMemCpy<int>(this->values,intarray,in_M);
	}
	else this->values=NULL;

	this->M=in_M;
}
/*}}}*/
/*FUNCTION IntVecParam::UnitConversion{{{*/
void  IntVecParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
