/*!\file Matpar.h
 * \brief: header file for matpar object
 */

#ifndef _MATPAR_H_
#define _MATPAR_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matpar: public Material{

	private: 
		int	  mid;
		IssmDouble  rho_ice; 
		IssmDouble  rho_water;
		IssmDouble  rho_freshwater;
		IssmDouble  mu_water;
		IssmDouble  heatcapacity;
		IssmDouble  thermalconductivity;
		IssmDouble  latentheat;
		IssmDouble  beta;
		IssmDouble  meltingpoint;
		IssmDouble  referencetemperature;
		IssmDouble  mixed_layer_capacity;
		IssmDouble  thermal_exchange_velocity;
		IssmDouble  g;

		/*hydrology: */		 
		IssmDouble  kn;			 
		IssmDouble  hydro_p;		 
		IssmDouble  hydro_q;		 
		IssmDouble  hydro_CR;			 
		IssmDouble  hydro_n; 

	public:
		Matpar();
		Matpar(int matpar_id, IoModel* iomodel);
		~Matpar();

		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void   InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void   InputUpdateFromVector(int* vector, int name, int type);
		void   InputUpdateFromVector(bool* vector, int name, int type);
		void   InputUpdateFromMatrixDakota(IssmDouble* matrix,int nrows,int ncols, int name, int type);
		void   InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void   InputUpdateFromVectorDakota(int* vector, int name, int type);
		void   InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void   InputUpdateFromConstant(IssmDouble constant, int name);
		void   InputUpdateFromConstant(int constant, int name);
		void   InputUpdateFromConstant(bool constant, int name);
		void   InputUpdateFromSolution(IssmDouble* solution);
		void   InputUpdateFromIoModel(int index, IoModel* iomodel){_error2_("not implemented yet");};
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   InputDuplicate(int original_enum,int new_enum){_error2_("not implemented yet");};
		void   Configure(Elements* elements);
		void   GetVectorFromInputs(Vector* vector,int input_enum){return;}
		/*}}}*/
		/*Numerics: {{{*/
		IssmDouble GetG();
		IssmDouble GetRhoIce();
		IssmDouble GetRhoWater();
		IssmDouble GetRhoFreshwater();
		IssmDouble GetMuWater();
		IssmDouble GetMixedLayerCapacity();
		IssmDouble GetThermalExchangeVelocity();
		IssmDouble GetHeatCapacity();
		IssmDouble GetThermalConductivity();
		IssmDouble GetLatentHeat();
		IssmDouble GetBeta();
		IssmDouble GetMeltingPoint();
		IssmDouble GetReferenceTemperature();
		IssmDouble GetKn();
		IssmDouble GetHydrologyP();
		IssmDouble GetHydrologyQ();
		IssmDouble GetHydrologyCR();
		IssmDouble GetHydrologyN();
		IssmDouble TMeltingPoint(IssmDouble pressure);
		IssmDouble PureIceEnthalpy(IssmDouble pressure);
		IssmDouble GetEnthalpyDiffusionParameter(IssmDouble enthalpy,IssmDouble pressure);
		void   EnthalpyToThermal(IssmDouble* ptemperature,IssmDouble* pwaterfraction,IssmDouble enthalpy,IssmDouble pressure);
		void   ThermalToEnthalpy(IssmDouble* penthalpy,IssmDouble temperature,IssmDouble waterfraction,IssmDouble pressure);
		/*}}}*/

};

#endif  /* _MATPAR_H_ */
