/*! \file DoubleExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEEXTERNALRESULT_H_
#define _DOUBLEEXTERNALRESULT_H_

/*Headers:*/
/*{{{*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		IssmDouble value;
		int    step;
		IssmDouble time;


		/*DoubleExternalResult constructors, destructors: {{{*/
		DoubleExternalResult();
		DoubleExternalResult(int id,int enum_type,IssmDouble value,int step,IssmDouble time);
		~DoubleExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _DOUBLEEXTERNALRESULT_H */
