/*!\file DoubleParam.c
 * \brief: implementation of the DoubleParam object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*DoubleParam constructors and destructor*/
/*FUNCTION DoubleParam::DoubleParam(){{{*/
DoubleParam::DoubleParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleParam::DoubleParam(int enum_type,IssmDouble value){{{*/
DoubleParam::DoubleParam(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleParam::~DoubleParam(){{{*/
DoubleParam::~DoubleParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleParam::Echo {{{*/
void DoubleParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleParam::DeepEcho{{{*/
void DoubleParam::DeepEcho(void){

	_printLine_("DoubleParam:");
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " << this->value);
}
/*}}}*/
/*FUNCTION DoubleParam::Id{{{*/
int    DoubleParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleParam::MyRank{{{*/
int    DoubleParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleParam::ObjectEnum{{{*/
int DoubleParam::ObjectEnum(void){

	return DoubleParamEnum;

}
/*}}}*/
/*FUNCTION DoubleParam::copy{{{*/
Object* DoubleParam::copy() {
	
	return new DoubleParam(this->enum_type,this->value);

}
/*}}}*/

/*DoubleParam virtual functions definitions: */
/*FUNCTION DoubleParam::GetParameterName{{{*/
void DoubleParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int* pinteger){{{*/
void DoubleParam::GetParameterValue(int* pinteger){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an integer");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(bool* pbool){{{*/
void DoubleParam::GetParameterValue(bool* pbool){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an bool");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM){{{*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){{{*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){{{*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){
	_error2_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
/*FUNCTION DoubleParam::UnitConversion{{{*/
void  DoubleParam::UnitConversion(int direction_enum){
	::UnitConversion(&this->value,1,direction_enum,this->enum_type);
}
/*}}}*/
