/*!\file OptionCell.cpp
 * \brief: implementation of the optionscell object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionCell::OptionCell(){{{*/
OptionCell::OptionCell(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionCell::~OptionCell(){{{*/
OptionCell::~OptionCell(){

	if (values){
		delete values;
		values    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionCell::Echo {{{*/
void  OptionCell::Echo(){

	char cstr[81];
	bool flag     = true;

	if(flag) _pprintLine_("OptionCell Echo:");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		if(flag) _pprintLine_("        values: " << cstr << " " << "cell");
	}
	else if(flag) _pprintLine_("        values: [empty]");
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho() {{{*/
void  OptionCell::DeepEcho(){

	char  indent[81]="";

	OptionCell::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho(char* indent) {{{*/
void  OptionCell::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	if(flag) _pprintLine_(indent << "OptionCell DeepEcho:");
	Option::DeepEcho(indent);

	xMemCpy<char>(indent2,indent,(strlen(indent)+1));
	strcat(indent2,"  ");

	if (values->Size()) {
		dims=xNew<int>(ndims);
		for (i=0; i<values->Size(); i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			if(flag) _pprintLine_(indent << "        values: -------- begin " << cstr << " --------");
			((Option *)values->GetObjectByOffset(i))->DeepEcho(indent2);
			if(flag) _pprintLine_(indent << "        values: --------  end  " << cstr << " --------");
		}
		xDelete<int>(dims);
	}
	else if(flag) _pprintLine_(indent << "        values: [empty]");
}
/*}}}*/
/*FUNCTION OptionCell::Name {{{*/
char* OptionCell::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionCell::NumEl {{{*/
int   OptionCell::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionCell::NDims {{{*/
int   OptionCell::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionCell::Size {{{*/
int*  OptionCell::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionCell::Get(Options** pvalue) {{{*/
void OptionCell::Get(Options** pvalue){

	/*Assign output pointer*/
	*pvalue=this->values;
}
/*}}}*/
