/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matice: public Material{

	private: 
		/*Id*/
		int	   mid;

		/*hooks: */
		Hook* helement;

	public:
		/*WARNING: input should not be public but it is an easy way to update B from T (using UpdateFromSolution) from Pentas*/
		Inputs*  inputs;

		/*Matice constructors, destructors: {{{*/
		Matice();
		Matice(int mid,int i, IoModel* iomodel);
		~Matice();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(IssmDouble* solution);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   InputDuplicate(int original_enum,int new_enum);
		void   Configure(Elements* elements);
		void   GetVectorFromInputs(Vector* vector,int input_enum);
		/*}}}*/
		/*Matice Numerics: {{{*/
		void   SetCurrentConfiguration(Elements* elementsin,Loads* loadsin,Nodes* nodesin,Vertices* verticesin,Materials* materialsin,Parameters* parametersin);
		void   GetViscosity2d(IssmDouble* pviscosity, IssmDouble* pepsilon);
		void   GetViscosity3d(IssmDouble* pviscosity3d, IssmDouble* pepsilon);
		void   GetViscosity3dStokes(IssmDouble* pviscosity3d, IssmDouble* epsilon);
		void   GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon);
		void   GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void   GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		IssmDouble GetB();
		IssmDouble GetBbar();
		IssmDouble GetN();
		bool   IsInput(int name);
		/*}}}*/
};

#endif  /* _MATICE_H_ */
