/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

/*Headers:*/
/*{{{*/
#include "./Load.h"
#include "../Node.h"
#include "../Elements/Element.h"

class Element;
/*}}}*/

class Penpair: public Load{

	private: 
		int		id;
		int analysis_type;
		
		Hook* hnodes;  //hook to 2 nodes
		Node** nodes;

		Parameters* parameters; //pointer to solution parameters

	public:

		/*Penpair constructors, destructors: {{{*/
		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids,int analysis_type);
		~Penpair();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols,int name, int type){_error2_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type){_error2_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(int* vector, int name, int type){_error2_("Not implemented yet!");}
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type){_error2_("Not implemented yet!");}
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(IssmDouble* solution){_error2_("Not implemented yet!");}
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error2_("not implemented yet");};
		/*}}}*/
			/*Load virtual functions definitions: {{{*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Matrix* Kff, Matrix* Kfs);
		void  CreatePVector(Vector* pf);
		void  CreateJacobianMatrix(Matrix* Jff);
		void  PenaltyCreateKMatrix(Matrix* Kff,Matrix* Kfs,IssmDouble kmax);
		void  PenaltyCreatePVector(Vector* pf, IssmDouble kmax);
		void  PenaltyCreateJacobianMatrix(Matrix* Jff,IssmDouble kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
			/*Penpair management: {{{*/
		ElementMatrix* PenaltyCreateKMatrixDiagnosticHoriz(IssmDouble kmax);
		ElementMatrix* PenaltyCreateKMatrixDiagnosticMacAyealPattyn(IssmDouble kmax);
		ElementMatrix* PenaltyCreateKMatrixDiagnosticStokes(IssmDouble kmax);
		ElementMatrix* PenaltyCreateKMatrixPrognostic(IssmDouble kmax);
		/*}}}*/
};

#endif  /* _PENPAIR_H_ */


