/*! \file TransientInput.h 
 *  \brief: header file for transientinput object
 */


#ifndef _TRANSIENTINPUT_H_
#define _TRANSIENTINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
class GaussTria;
class Parameters;
/*}}}*/

class TransientInput: public Input{

	public:
		int     enum_type;
		int     numtimesteps;
		Inputs* inputs;
		IssmDouble* timesteps;
		Parameters* parameters; //to find current time.

		/*TransientInput constructors, destructors: {{{*/
		TransientInput();
		TransientInput(int enum_type);
		~TransientInput();
		void AddTimeInput(Input* input,IssmDouble time);
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TransientInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* forcingB){_error2_("not implemented yet");};
		Input* PointwiseMin(Input* forcingB){_error2_("not implemented yet");};
		Input* PointwiseMax(Input* forcingB){_error2_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmDouble time);
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error2_("not implemented yet");};
		void GetInputValue(int* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time);
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetInputAverage(IssmDouble* pvalue);
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum){_error2_("not implemented yet");};
		void Scale(IssmDouble scale_factor){_error2_("not implemented yet");};
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error2_("not implemented yet");};
		void AXPY(Input* xforcing,IssmDouble scalar){_error2_("not implemented yet");};
		void Constrain(IssmDouble cm_min, IssmDouble cm_max){_error2_("not implemented yet");};
		IssmDouble InfinityNorm(void);
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void){_error2_("not supported yet");}
		void VerticallyIntegrate(Input* thickness_forcing){_error2_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values){_error2_("not supported yet");};
      void GetTimeValues(IssmDouble* values,IssmDouble time){_error2_("not implemented yet");};
		Input* GetTimeInput(IssmDouble time);
		/*}}}*/

};
#endif  /* _TRANSIENTINPUT_H */
