/*!\file GaussTria.h
 * \brief: header file for node object
 */

#ifndef _GAUSSTRIA_H_
#define _GAUSSTRIA_H_

/*Headers:*/
/*{{{*/
#include "./../../shared/shared.h"
/*}}}*/

class GaussTria{

	private:
		int numgauss;
		IssmPDouble* weights;
		IssmPDouble* coords1;
		IssmPDouble* coords2;
		IssmPDouble* coords3;

	public:
		IssmPDouble weight;
		IssmPDouble coord1;
		IssmPDouble coord2;
		IssmPDouble coord3;
		
	public:

		/*GaussTria constructors, destructors*/
		GaussTria();
		GaussTria(int order);
		GaussTria(int index1,int index2,int order);
		~GaussTria();

		/*Methods*/
		int  begin(void);
		int  end(void);
		void Echo(void);
		void GaussFromCoords(IssmPDouble x1,IssmPDouble y1,IssmPDouble* xyz_list);
		void GaussPoint(int ig);
		void GaussVertex(int iv);
		void GaussCenter(void);
		void GaussEdgeCenter(int index1,int index2);
};
#endif  /* _GAUSSTRIA_H_ */
