/*!\file Segment.c
 * \brief: implementation of the Segment object
 */

/*Include files: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./objects.h"
#include "../Container/Container.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/include.h"
/*}}}*/

/*Segment constructors and destructors:*/
/*FUNCTION Segment::Segment() default constructor {{{*/
Segment::Segment(){
	this->eid=UNDEF;
	this->x1=UNDEF;
	this->y1=UNDEF;
	this->x2=UNDEF;
	this->y2=UNDEF;
}
/*}}}*/
/*FUNCTION Segment::Segment(int eid, IssmDouble x1,IssmDouble y1,IssmDouble x2, IssmDouble y2){{{*/
Segment::Segment(int segment_eid, IssmDouble segment_x1,IssmDouble segment_y1,IssmDouble segment_x2, IssmDouble segment_y2){

	this->eid=segment_eid;
	this->x1=segment_x1;
	this->y1=segment_y1;
	this->x2=segment_x2;
	this->y2=segment_y2;

}
/*}}}*/
/*FUNCTION Segment::~Segment(){{{*/
Segment::~Segment(){
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION Segment::Echo{{{*/
void Segment::Echo(void){

	_printLine_("Segment:");
	_printLine_("   eid: " << eid);
	_printLine_("   node 1: " << this->x1 << "|" << this->y1);
	_printLine_("   node 2: " << this->x2 << "|" << this->y2);

}
/*}}}*/
/*FUNCTION Segment::DeepEcho{{{*/
void Segment::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Segment::Id{{{*/
int    Segment::Id(void){ return eid; }
/*}}}*/
/*FUNCTION Segment::MyRank{{{*/
int    Segment::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
/*FUNCTION Segment::ObjectEnum{{{*/
int Segment::ObjectEnum(void){

	return SegmentEnum;

}
/*}}}*/
/*FUNCTION Segment::copy {{{*/
Object* Segment::copy() {
	return new Segment(this->eid,this->x1,this->y1,this->x2,this->y2);

}

/*}}}*/
