#!/bin/bash
#generate a tex file from a html page (I AM only... sorry guys)

cp installation.html tempfile.tex

#----------------  remove pure html ------------------

#remove header
cat tempfile.tex | sed '/<html/,/content start-->/d' > tempfile2.tex
mv tempfile2.tex tempfile.tex

#remove footer
cat tempfile.tex | sed '/content end-->/,/<\/html>/d' > tempfile2.tex
mv tempfile2.tex tempfile.tex

#remove table of content
cat tempfile.tex | sed '/<!-- toc start-->/,/<!-- toc end-->/d' > tempfile2.tex
mv tempfile2.tex tempfile.tex

#remove <p> and </p>
cat tempfile.tex | sed -e "s/<p>//g" | sed -e "s/<\/p>//g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#remove <br>
cat tempfile.tex | sed -e "s/<br>//g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#----------------  html to latex substitution ------------------

#buid section <h1> and <h1 ...">
cat tempfile.tex | sed -e "s/<h1>/\\\begin{section}{/g" | sed -e "s-<h1.*\">-\\\begin{section}{-" > tempfile2.tex
mv tempfile2.tex tempfile.tex
cat tempfile.tex | sed -e "s/<\/h1>/}/g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#build subsection
cat tempfile.tex | sed -e "s/<h2>/\\\begin{subsection}{/g" | sed -e "s/<\/h2>/}/g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#<ul> -> itemize
cat tempfile.tex | sed -e "s/<ul>/\\\begin{itemize}/g" | sed -e "s/<\/ul>/\\\end{itemize}/g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#<li> -> item
cat tempfile.tex | sed -e "s/<li>/\\\item /g" |  sed -e "s/<\/li>//g"> tempfile2.tex
mv tempfile2.tex tempfile.tex

#take care of hyper links
cat tempfile.tex | sed -e "s/<a href=\"/\\\href{/g" | sed "/\\\href{/s/\">/}{/" > tempfile2.tex
mv tempfile2.tex tempfile.tex
cat tempfile.tex | sed -e "s/<\/a>/}/g" > tempfile2.tex
mv tempfile2.tex tempfile.tex

#----------------  specific substitution ------------------

#take care of "fragment division before removing all division
cat tempfile.tex | sed -e "s/<div class=\"fragment\">/\\\begin{verbatim}/" > tempfile2.tex
mv tempfile2.tex tempfile.tex
cat tempfile.tex | sed -e "s/<\/div><!-- end fragment-->/\\\end{verbatim}/" > tempfile2.tex
mv tempfile2.tex tempfile.tex
cat tempfile.tex | sed -e "/<div/d" | sed -e "s/<\/div>//g" > tempfile2.tex
mv tempfile2.tex tempfile.tex
