#ISSM_DIR and ISSM_ARCH should have been defined already in your shell settings file (.bashrc, .cshrc, etc ...)

#Windows compilers: 
if [[ "$ISSM_ARCH" == "cygwin-intel" ]]; then
	source $ISSM_DIR/externalpackages/windows/windows_environment.sh
fi

source $ISSM_DIR/etc/environment_variables.sh

#Do we have any command line arguments? (such as MATLAB_DIR=otherdirthandefault), source them after exporting the variables
#to environment.
for i in $@
do
	eval $i
done

#CRON utilities
PATH="$PATH:$ISSM_DIR/cron"

#scripts
PATH="$PATH:$ISSM_DIR/scripts"

##MATLAB
export MATLAB_DIR
PATH="$MATLAB_DIR/bin:$PATH" #take precedence over /usr/local/bin/matlab
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$MATLAB_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$MATLAB_DIR/lib"
#export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$MATLAB_DIR/bin/glnxa64"
#export LD_RUN_PATH="$LD_RUN_PATH:$MATLAB_DIR/bin/glnxa64"

#MPI
export MPI_DIR
PATH="$MPI_DIR/bin:$PATH"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$MPI_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$MPI_DIR/lib"
export MANPATH="$MANPATH:$MPI_DIR/man"
export MPIRUN_NPROCS=24

#PETSC
export PETSC_DIR
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$PETSC_DIR/lib/$ISSM_ARCH:$PETSC_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$PETSC_DIR/lib/$ISSM_ARCH"

#SLEPC
export SLEPC_DIR
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SLEPC_DIR/lib/$ISSM_ARCH"
export LD_RUN_PATH="$LD_RUN_PATH:$SLEPC_DIR/lib/$ISSM_ARCH"

#Dakota
export DAKOTA_DIR
PATH="$PATH:$DAKOTA_DIR/bin"
export MANPATH="$MANPATH:$MPI_DIR/man:$DAKOTA_DIR/docs/man:$DAKOTA_DIR/docs/man-ref"

#Qhull
export QHULL_DIR
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$QHULL_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$QHULL_DIR/lib"

#Doxygen
export DOXYGEN_DIR
MANPATH="$MANPATH:$DOXYGEN_DIR/man"
PATH="$PATH:$DOXYGEN_DIR/bin"

#MTOC
export MTOC_DIR
PATH="$PATH:$MTOC_DIR"

#TRIANGLE
export TRIANGLE_DIR

#METIS
export METIS_DIR
	
#BLAS
export BLAS_DIR

#LAPACK
export LAPACK_DIR

#SCALAPACK
export SCALAPACK_DIR

#PLAPACK
export PLAPACK_DIR

#BLACS
export BLACS_DIR

#YAMS
export YAMS_DIR
PATH="$PATH:$YAMS_DIR"

#BAMG
export BAMG_DIR
PATH="$PATH:$BAMG_DIR"

#TEX2IM
export TEX2IM_DIR
PATH="$PATH:$TEX2IM_DIR"

#SOWING
export SOWING_DIR
PATH="$PATH:$SOWING_DIR/bin"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SOWING_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$SOWING_DIR/lib"
export MANPATH="$MANPATH:$SOWING_DIR/man"

#Chaco
export CHACO_DIR
PATH="$PATH:$CHACO_DIR"

#MeshPart
export MESHPART_DIR
PATH="$PATH:$MESHPART_DIR"

#SCOTCH
export SCOTCH_DIR
PATH="$PATH:$SCOTCH_DIR"
export MANPATH="$MANPATH:$SCOTCH_DIR/man"

#AUTOCONF
export AUTOCONF_DIR
PATH="$AUTOCONF_DIR/bin:$PATH"

#AUTOMAKE
export AUTOMAKE_DIR
PATH="$AUTOMAKE_DIR/bin:$PATH"

export LIBTOOL_DIR
PATH="$LIBTOOL_DIR/bin:$PATH"

#BORLAND
export BORLAND_DIR
PATH="$PATH:$BORLAND_DIR/Bin"

#INTEL
#export INTEL_DIR
#PATH="$PATH:$INTEL_DIR"
#source $ISSM_DIR/externalpackages/intel/intel.sh

#SDK
export SDK_DIR
PATH="$PATH:$SDK_DIR"

#SSH
export SSH_DIR
PATH="$PATH:$SSH_DIR"

#VALGRIND
export VALGRIND_DIR
PATH="$PATH:$VALGRIND_DIR"

#GRAPHVIZ
export GRAPHVIZ_DIR
PATH="$PATH:$GRAPHVIZ_DIR"

#CPPCHECK
export CPPCHECK_DIR
PATH="$PATH:$CPPCHECK_DIR"

#GDAL
export GDAL_DIR
PATH="$GDAL_DIR/bin:$PATH"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$GDAL_DIR/lib"

#MERCURIAL
export PYTHONPATH="$PYTHONPATH:$MERCURIAL_DIR/mercurial/pure/"
export PATH="$PATH:$MERCURIAL_DIR/"

#BOOST
export BOOSTROOT
export BOOST_DIR
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$BOOST_DIR/lib"
export DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH:$BOOST_DIR/lib"
export PATH="$PATH:$BOOST_DIR/bin"

#XERCES
export XERCESROOT 
export XERCESCROOT

#xaifBooster
export XAIFBOOSTERROOT
export XAIFBOOSTER_HOME
export XAIF_DIR
export PLATFORM

#angel
export ANGELROOT

#openanalysis
export OPENANALYSISROOT
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$OPENANALYSISROOT/lib"

#JAVA
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$JVM_DIR"

#BBFTP
export PATH="$PATH:$BBFTP_DIR/bin"

#ADIC
export PATH="$PATH:$ADIC_DIR/bin"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$ADIC_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$ADIC_DIR/lib"

#COLPACK
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$COLPACK_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$COLPACK_DIR/lib"

#ECLIPSE
export PATH="$PATH:$ECLIPSE_DIR"

#FLAIM
export FLAIM_DIR

#APPSCAN
export PATH="$PATH:$APPSCAN_DIR/install/bin"
export PATH="$PATH:$APPSCAN_DIR/bin"

#CPPCHECK
export PATH="$PATH:$CPPCHECK_DIR/bin"

#RATS
export PATH="$PATH:$RATS_DIR/bin"

#DYSON
export PATH="$PATH:$DYSON_DIR"

#CMAKE
export PATH="$PATH:$CMAKE_DIR/bin"

#SHAPELIB
export PATH="$PATH:$SHAPELIB_DIR/exec"

#CCCL
export PATH="$PATH:$CCCL_DIR/bin"

#PACKAGEMAKER
export PATH="$PATH:$PACKAGEMAKER_DIR"

#ANDROID_NDK:
export ANDROID_NDK_DIR
export PATH="$PATH:$ANDROID_NDK_DIR/"

#ANDROID_DIR
export ANDROID_DIR

#ANDROID_SDK
export PATH="$PATH:$ANDROID_SDK_DIR/"

#ANDROID_ANT
export PATH="$PATH:$ANDROID_ANT_DIR/"

#GSL
export PATH="$PATH:$GSL_DIR/bin"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$GSL_DIR/lib"
export LD_RUN_PATH="$LD_RUN_PATH:$GSL_DIR/lib"

#GMAKE
export PATH="$GMAKE_DIR/bin:$PATH"

#PYTHON
export PATH="$PYTHON_DIR/bin:$PATH"
export PYTHONPATH="$PYTHONPATH:$ISSM_DIR/src/modules/python"
export LD_LIBRARY_PATH=$ISSM_DIR/src/modules/python:$ISSM_DIR/externalpackages/python/install/lib:$LD_LIBRARY_PATH
export PYTHONSTARTUP

#MODELE
export PATH="$MODELE_DIR/src/exec:$PATH"

#GIT
export PATH="$PATH:$GIT_DIR/install/bin"

#NCVIEW
export PATH="$PATH:$NCVIEW_DIR/install"

#TCLX
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$TCLX_DIR"
export LD_RUN_PATH="$LD_RUN_PATH:$TCLX_DIR"


#ASPELL
export PATH="$ASPELL_DIR/install/bin:$PATH"


#ESMF
export ESMF_DIR=$ISSM_DIR/externalpackages/esmf/esmf
export ESMF_COMPILER=gfortran
export ESMF_COMM=mpich2

#HDF5
export DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH:$HDF5_DIR/lib"
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$HDF5_DIR/lib"
export LIBRARY_PATH="$LIBRARY_PATH:$HDF5_DIR/lib"
export C_INCLUDE_PATH="$C_INCLUDE_PATH:$HDF5_DIR/include"

