function displaytransient(md)
%DISPLAYTRANSIENT - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaytransient(md)

displaydiagnostic(md);
disp(' ');
displaythermal(md);
disp(' ');
displayprognostic(md);
disp(' ');

disp(sprintf('   Transient solution parameters:\n'));

fielddisplay(md,'timestepping','adptative time stepping implemented - default to 0');
fielddisplay(md,'deltaH','minimum thickness difference between two time steps');
fielddisplay(md,'DeltaH','maximum thickness difference between two time steps');
fielddisplay(md,'deltaT','minimum temperature difference between two time steps');
fielddisplay(md,'DeltaT','maximum temperature difference between two time steps');
fielddisplay(md,'timeacc','multiplier to time step when time stepping increases time step');
fielddisplay(md,'timedec','multiplier to time step when time stepping decresaes time step');
