function displaymesh2grid(md)
%DISPLAYMESH2GRID - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaymesh2grid(md)

disp(sprintf('   Mesh2grid solution parameters:\n'));

fielddisplay(md,'mesh2grid_parameters','list of parameters for which mesh 2 grid interpolation is carried out; ex: {''drag''}, or {''drag'',''B''}');
fielddisplay(md,'mesh2grid_interpolation','list of interpolation (''node'' or ''element'') for each parameter ex: {''node''}, or {''node'',''element''}');
fielddisplay(md,'mesh2grid_filter','list of filter (''average'' or ''nearest'') for each parameter ex: {''average''}, or {''average'',''nearest''}');
fielddisplay(md,'mesh2grid_cornereast','corner east of square grid');
fielddisplay(md,'mesh2grid_cornernorth','corner north of square grid');
fielddisplay(md,'mesh2grid_xposting','x  posting of grid [m]');
fielddisplay(md,'mesh2grid_yposting','y  posting of grid [m]');
fielddisplay(md,'mesh2grid_nlines','number of grid lines');
fielddisplay(md,'mesh2grid_ncolumns','number of grid columns');
fielddisplay(md,'mesh2grid_windowsize','size of filter');
