function displayoutlines(md);
%DISPLAYOUTLINES - display outline information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays outline information from model md, 
%   only if requested.
%
%   Usage:
%      displayoutline(md)

disp(sprintf('\n   Outlines:'));
fielddisplay(md,'domainoutline','domain outline Argus file');
fielddisplay(md,'riftoutline','rift outline Argus file');
fielddisplay(md,'iceshelfoutline','ice shelf outline Argus file');
fielddisplay(md,'icesheetoutline','ice sheet outline Argus file');

disp(sprintf('\n   Model files:'));
fielddisplay(md,'parameterfile','parameter file content');
