function displayresults(md)
%DISPLAYRESULTS - display results
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays results from model md, 
%   only if requested.
%
%   Usage:
%      displayresults(md)

disp(sprintf('   Results:'));

disp(sprintf('\n      solution results:'));
fielddisplay(md,'results','');

disp(sprintf('\n      output parameters:'));
fielddisplay(md,'stress','stress [Pa]');
fielddisplay(md,'deviatoricstress','deviatoric stress [Pa]');
fielddisplay(md,'strainrate','strain rate [1/yr]');
