function displaybc(md)
%DISPLAYBC - display of the boundary conditions fileds
%
%   to avoid clobbering display.m with every field from model md, 
%   we create this routine that displays boundary conditions  from model md, 
%   only if requested.
%
%   Usage:
%      displaybc(md)

disp(sprintf('   Boundary conditions:'));

disp(sprintf('\n      geography:'));
fielddisplay(md,'gridonboundary','grid on boundary flags list');
fielddisplay(md,'elementoniceshelf','element on ice shelf flags list');
fielddisplay(md,'gridoniceshelf','grid on ice shelf flags list');
fielddisplay(md,'elementonicesheet','element on ice sheet flags list');
fielddisplay(md,'gridonicesheet','grid on ice sheet flags list');

disp(sprintf('\n      diagnostic:'));
fielddisplay(md,'gridondirichlet_diag','grid on dirichlet flags list');
fielddisplay(md,'dirichletvalues_diag','values of the dirichlet [m/a]');
fielddisplay(md,'segmentonneumann_diag','segments on ice front list');
fielddisplay(md,'neumannvalues_diag','values of the Neumann [N]');

disp(sprintf('\n      prognostic:'));
fielddisplay(md,'gridondirichlet_prog','grid on dirichlet flags list');
fielddisplay(md,'dirichletvalues_prog','values of the dirichlet [m]');
fielddisplay(md,'segmentonneumann_prog','segments on ice front list');
fielddisplay(md,'neumannvalues_prog','values of the Neumann [m/a]');

disp(sprintf('\n      thermal:'));
fielddisplay(md,'gridondirichlet_thermal','grid on dirichlet flags list');
fielddisplay(md,'dirichletvalues_thermal','values of the dirichlet [m]');
fielddisplay(md,'melting','melting rate [m/a]');
