function ismodelselfconsistent(md),
%ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
%
%   Usage:
%      ismodelselfconsistent(md),

%initialize consistency as true
md.private.isconsistent=true;

%Get solution and associated analyses
solution=md.private.solution;
[analyses,numanalyses]=AnalysisConfiguration(solution);

%Go through a model field, check that it is a class, and call checkconsistency
fields=properties('model');
for i=1:length(fields),
	field=fields{i};

	%Some properties do not need to be checked
	if ismember(field,{'results' 'debug' 'radaroverlay'}),
		continue;
	end

	%Check that current field is an object
	if ~isobject(md.(field))
		md=checkmessage(md,['field ''' char(field) ''' is not an object']);
	end

	%Check consistency of the object
	if verLessThan('matlab', '7.6')
		md=checkconsistency(md.(field),md,solution,analyses);
	else
		md=md.(field).checkconsistency(md,solution,analyses);
	end
end

%error message if mode is not consistent
if md.private.isconsistent==false,
	error('Model not consistent, see messages above');
end
