"""
ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
 
    Usage:
       ismodelselfconsistent(md),
"""

def ismodelselfconsistent(md):

	#initialize consistency as true
	md.private.isconsistent=true

	#Get solution and associated analyses
	solution=md.private.solution
	analyses,numanalyses=AnalysisConfiguration(solution)

	#Go through a model fields, check that it is a class, and call checkconsistency
	fields=variables('model')
	for field in fields:

		#Some properties do not need to be checked
		if field in ['results','debug','radaroverlay']:
			continue

		#Check that current field is an object
		if not hasattr(getattr(md,field),'checkconsistency'):
			md=checkmessage(md,"field '%s' is not an object." % field)

		#Check consistency of the object
		exec("md.%s.checkconsistency(md,solution,analyses)" % field)

	#error message if mode is not consistent
	if not md.private.isconsistent:
		raise RuntimeError('Model not consistent, see messages above.')

