/*
 * UpdateElementsTransient:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, Parameters* parameters,IoModel* iomodel,int analysis_counter,int analysis_type){

	bool   ispdd;
	bool   isdelta18o;
	IssmDouble *size, Delta18oTimeSerie,Delta18oSurfaceTimeSerie ;

	/*Fetch data needed: */
	iomodel->Constant(&ispdd,SurfaceforcingsIspddEnum);
	iomodel->Constant(&isdelta18o,SurfaceforcingsIsdelta18oEnum);

	if(ispdd){
	        iomodel->FetchDataToInput(elements,ThermalSpctemperatureEnum);
	        if(isdelta18o){
	                  iomodel->FetchDataToInput(elements,SurfaceforcingsDelta18oEnum);
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsDelta18oSurfaceEnum);
 
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsDelta18oTemperaturesLgmEnum);
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsDelta18oTemperaturesPresentdayEnum);
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsPrecipitationsPresentdayEnum);
	        }
	        else{
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsPrecipitationEnum);
	        	  iomodel->FetchDataToInput(elements,SurfaceforcingsMonthlytemperaturesEnum);
	        }
	}
	else{
		iomodel->FetchDataToInput(elements,SurfaceforcingsMassBalanceEnum);
	}
}
