/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;
	bool issmbgradients;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(PrognosticAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&issmbgradients,SurfaceforcingsIssmbgradientsEnum);


	if(issmbgradients){
	  _printf_(VerboseSolution(),"	call smb gradients module\n");
	  SmbGradientsx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}

	if(VerboseSolution()) _pprintLine_("   call computational core");
	solver_linear(femmodel);
	
	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}
}
