"""
%ISPETSC - figure out if PETSC package was compiled with ISSM
%
%   Usage:
%       flag=ispetsc();
"""

import os
from issmdir import *
from MatlabFuncs import *

def ispetsc():

	configfile=os.path.join(issmdir(),'bin','config.h')    #should find it in the install target
	if not os.path.exists(configfile):
		raise RuntimeError("File '%s' not found. ISSM has not been configured yet!" % configfile)

	#go through the file, and recover the line we want
	flag=2
	try:
		fid=open(configfile,'r')
	except IOError as e:
		print "could not open file: '%s'" % configfile
		raise IOError(e)

	for tline in fid:
		if strncmp(tline,'/* #undef _HAVE_PETSC_ */',25):
			flag=0
			break
		if  strncmp(tline,'#define _HAVE_PETSC_',20):
			flag=1
			break

	fid.close()
	if flag==2:
		raise RuntimeError("could not determine whether PETSC was or was not compiled.")

	return flag

