"""
ISSMSSH - wrapper for OS independent ssh command.
 
    usage: 
       issmssh(host,command)
"""

import socket
import platform
import subprocess
import os
from MatlabFuncs import *

def issmssh(host,login,port,command):

	#first get hostname 
	hostname=socket.gethostname().lower().split('.')[0]

	#if same as host, just run the command. 
	if strcmpi(host,hostname):
		subprocess.call(command,shell=True)
	else:
		if 'Windows' in platform.system():
			#use the putty project plink.exe: it should be in the path.
		
			#get ISSM_DIR variable
			if 'ISSM_DIR_WIN' in os.environ:
				ISSM_DIR=os.environ['ISSM_DIR_WIN'][1:-2]
			else:
				raise OSError("issmssh error message: could not find ISSM_DIR_WIN environment variable.")

			username=raw_input('Username: (quoted string) ')
			key=raw_input('Key: (quoted string) ')

			subprocess.call('%s/externalpackages/ssh/plink.exe -ssh -l "%s" -pw "%s" %s "%s"' % (ISSM_DIR,username,key,host,command),shell=True);

		else:
			#just use standard unix ssh
			if port:
				subprocess.call('ssh -l %s -p %d localhost "%s"' % (login,port,command),shell=True)
			else:
				subprocess.call('ssh -l %s %s "%s"' % (login,host,command),shell=True)

