#!/bin/bash
source $ANDROID_DIR/android_aux.sh

# use matlab? 
matlab=0

# Some cleanup 
rm -rf install triangle
mkdir install

# Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/triangle.zip' 'triangle.zip'

# Untar 
cd install
cp ../triangle.zip ./
unzip triangle.zip

# copy new makefile
cp ../configs//android/configure.make ./
cp ../makefile ./

# Patch triangle.c 
if [[ $matlab == "1" ]];then
	patch triangle.c ../triangle.c.patch.matlab
else
	patch triangle.c ../triangle.c.patch.python
fi

# Compile triangle
make -j $j

# Patch triangle.h
patch triangle.h ../triangle.h.patch
