#!/bin/bash

source $ANDROID_DIR/android_aux.sh

if [[ $step == "1" || $step == "0" ]]; then

    #Some cleanup
    rm -rf src install gsl-1.15
    mkdir src install

    #Download from ISSM server
    $ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/gsl-1.15.tar.gz' 'gsl-1.15.tar.gz'

    #Untar 
    tar -zxvf  gsl-1.15.tar.gz

    #Move gsl into src directory
    mv gsl-1.15/* src
    rm -rf gsl-1.15
fi

#Configure gsl
if [[ $step == "2" || $step == "0" ]]; then
    cd src
    
    autoreconf -iv --force -I "$ISSM_DIR/m4/"

    ./configure \
        --build="i386-apple-darwin10.8.0" \
        --host=$host_triplet\
	    --prefix="$ISSM_DIR/externalpackages/gsl/install/" 
fi

#Compile gsl
if [[ $step == "3" || $step == "0" ]]; then
    if [ -z $1 ]; then
	    make 12
    else
	    make -j 12
    fi

    make install
fi
