#!/bin/bash
#
# android_aux.sh serves as an auxiliary script for all installation
# scripts with the Android suffix.
#
# TODO: include M4 macros for generic options.
#

sdk_rev=20
ndk_rev=8
api_levels="android-14,android-15,android-16"
host_triplet="arm-linux-androideabi"
default_droid="android-4.1"

step=0;
j=1;

echo Number of arguments is: $#
for arg in $* 
do 
    if [[ "$arg" =~ --step=([0-9])* ]]; then
        step=${BASH_REMATCH[1]}; 
        echo "Setting step to: " $step
    elif [[ "$arg" =~ -j=([0-9])* ]]; then
        j=${BASH_REMATCH[1]}; 
        echo "Number of jobs set to: " $j
    else
        echo "Option not recognized"
    fi
done
