#!/bin/bash

#Some cleanup
rm -rf install src
rm -rf Python-2.7.2
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py http://issm.jpl.nasa.gov/files/externalpackages/Python-2.7.2.tgz Python-2.7.2.tgz

#exports
export CC

#Untar and move python into install directory
tar -zxvf  Python-2.7.2.tgz
mv Python-2.7.2/* src
rm -rf Python-2.7.2

#Configure doxygen
cd src 
./configure \
 --enable-framework="$ISSM_DIR/externalpackages/python/install/Library/Frameworks" 

#obsolete? 
#./configure --prefix="$ISSM_DIR/externalpackages/python/install" --enable-framework="$ISSM_DIR/externalpackages/python/install"

#make
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install

cd ../install
ln -s Library/Frameworks/Python.framework/Headers include
ln -s Library/Frameworks/Python.framework/Versions/2.7/lib lib

#Patch pyport.h:
cd include
patch pyport.h ../patch/pyport.h.patch
