#!/bin/bash

#Some cleanup
rm -rf install src
rm -rf Python-2.7.2
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py http://issm.jpl.nasa.gov/files/externalpackages/Python-2.7.2.tgz Python-2.7.2.tgz

#exports
export CC

#Untar and move python into install directory
tar -zxvf  Python-2.7.2.tgz
mv Python-2.7.2/* src
rm -rf Python-2.7.2

#Configure python
cd src 
./configure \
 --prefix="$ISSM_DIR/externalpackages/python/install" \
 --enable-shared

if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install

cd ../install/include
cp python2.7/* ./
cd ../lib
ln -s  libpython2.7.so.1.0 libpython.so
