"""
LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
 
    Usage:
       md=loadresultsfromdisk(md=False,filename=False);
"""

import os

def loadresultsfromdisk(md,filename):

	#check number of inputs/outputs
	if not md or not filename:
		raise ValueError("loadresultsfromdisk: error message.")

	if not md.qmu.isdakota:

		#Check that file exists
		if not os.path.exists(filename):
			raise ValueError("binary file '%s' not found." % filename)

		#initialize md.results if not a structure yet
		if not isinstance(md.results,dict):
			md.results={}

		#load results onto model
		structure=parseresultsfromdisk(filename,~md.settings.io_gather)
		if not len(structure):
			raise RuntimeError("No result found in binary file '%s'. Check for solution crash." % filename)
		end
		md.results[structure[1]['SolutionType']]=structure;

		#recover solution_type from results
		md.private.solution=structure[1]['SolutionType']

		#read log files onto fields
		if os.path.exists(md.miscellaneous.name+'.errlog'):
			with open(md.miscellaneous.name+'.errlog','r') as f:
				md.results[structure[1]['SolutionType']]['errlog']=[line[:-1] for line in f]
		else:
			md.results[structure[1]['SolutionType']]['errlog']=[]

		if os.path.exists(md.miscellaneous.name+'.outlog'):
			with open(md.miscellaneous.name+'.outlog','r') as f:
				md.results[structure[1]['SolutionType']]['outlog']=[line[:-1] for line in f]
		else:
			md.results[structure[1]['SolutionType']]['outlog']=[]

		if len(md.results[structure[1]['SolutionType']]['errlog']):
			print ("loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields.")

	#post processes qmu results if necessary
	else:

		if not isinstance(md.private.solution,str):
			md.private.solution=EnumToString(md.private.solution)
		md=postqmu(md)
		os.chdir('..')

	return md

