"""
ISSMDIR - Get ISSM_DIR environment variable
 
    Usage:
       ISSM_DIR=issmdir()
"""

import platform
import os
from MatlabFuncs import *

def issmdir():

	if not 'Windows' in platform.system():
		ISSM_DIR =os.environ['ISSM_DIR']
	else:
		ISSM_DIR =os.environ['ISSM_DIR_WIN']
		if strcmpi(ISSM_DIR[-1],'/') or strcmpi(ISSM_DIR[-1],'\\'):
			ISSM_DIR = ISSM_DIR[:-1]    #shave off the last '/'

	if not ISSM_DIR:
		raise RuntimeError("issmdir error message: 'ISSM_DIR' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!")

	return ISSM_DIR

