/*
 * DataSet.h: declaration of DataSet,Parameters and Inputs classes
 */

#ifndef _CONTAINER_DATASET_H_
#define _CONTAINER_DATASET_H_

#include <vector>
#include "../objects/Object.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

/*forward declarations */
class Elements;
class Loads;
class Nodes;
class Vertices;
class Materials;
class Parameters;
class Patch;
class Results;
class Patch;

class DataSet{
	
	public: 
		
		/*internals: */
		std::vector<Object*> objects;
		
		/*type of dataset: */
		int             enum_type;
		
		/*sorting: */
		int             sorted;
		int             presorted;
		int*            sorted_ids;
		int*            id_offsets;

		/*constructors, destructors: {{{*/
		DataSet();
		DataSet(int enum_type);
		~DataSet();
		/*}}}*/
		/*management: {{{*/
		int   GetEnum();
		int   GetEnum(int offset);
		void  Echo();
		void  DeepEcho();
		int   AddObject(Object* object);
		int   DeleteObject(int id);
		int   Size();
		void  clear();
		Object* GetObjectByOffset(int offset);
		Object* GetObjectById(int* poffset,int eid);
		void  Presort();
		void  SetSorting(int* in_sorted_ids,int* in_id_offsets);
		void  Sort();
		DataSet* Copy(void);
		int   DeleteObject(Object* object);
		Results* SpawnTriaResults(int* indices);
		/*}}}*/

};

#endif
