function result=ReadData(fid)
%READDATA - ...
%
%   Usage:
%      field=ReadData(fid)


%read field
[length,count]=fread(fid,1,'int');

if count==0,
	result=struct([]);
else
	fieldname=fread(fid,length,'char');
	fieldname=fieldname(1:end-1)';
	fieldname=char(fieldname);
	time=fread(fid,1,'double');
	step=fread(fid,1,'int');

	type=fread(fid,1,'int');
	ssize=fread(fid,1,'int');
	if type==1,
		field=fread(fid,ssize,'double');
	else
		field=fread(fid,ssize,'char');
		field=char(field(1:end-1)');
	end

	result.fieldname=fieldname;
	result.time=time;
	result.step=step;
	result.field=field;
end
