#!/bin/bash

#Some cleanup
version=3.6.1
rm -rf src install octave-$version 
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py "http://issm.jpl.nasa.gov/files/externalpackages/octave-$version.tar.gz" "octave-$version.tar.gz"

#Untar 
tar -zxvf  octave-$version.tar.gz

#Move octave into install directory
mv octave-$version/* src
rm -rf octave-$version

#install
cd src 
./configure --prefix=$ISSM_DIR/externalpackages/octave/install --disable-readline

if [ -z $NUMCPUS ];
then
	make
	make install
else
	make -j $NUMCPUS
	make -j $NUMCPUS install
fi
