#!/bin/bash
#wget http://python.org/ftp/python/version/Python-version.tgz

#version=3.2.2
version=2.7.2

#Some cleanup
rm -rf install src
rm -rf Python-$version
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py http://issm.jpl.nasa.gov/files/externalpackages/Python-$version.tgz Python-$version.tgz

#exports
export CC
export MACOSX_DEPLOYMENT_TARGET=10.6

#Untar and move python into install directory
tar -zxvf  Python-$version.tgz
mv Python-$version/* src
rm -rf Python-$version

#Configure doxygen
cd src 
# --enable-framework needs to have the form "$SOME_PATH/Library/Frameworks" to avoid installing components in /Applications directory
# --prefix is recognized as $SOME_PATH as long as this form is taken, so it's not necessary to include
./configure --enable-framework="$ISSM_DIR/externalpackages/python/install/Library/Frameworks" 
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install

#Some modifications to be done in case version is 3.2: 
if [[ $version == "3.2.2" ]]; then 
	cd install/bin
	ln -s python3.2 python 
	cd ../
	ln -s Python.framework/Versions/3.2/include/python3.2m include
	ln -s Python.framework/Versions/3.2/lib/ lib
fi

#Some modifications to be done in case version is 2.7
if [[ $version == "2.7.2" ]]; then 
	cd ../install
	ln -s Library/Frameworks/Python.framework/Headers include
	ln -s Library/Frameworks/Python.framework/Versions/2.7/lib lib
fi
