#!/bin/bash
PYVERSION=2.7
PYTHON=python${PYVERSION}

#1: install numpy
#2 install scipy
#3 erase
install=2

# gfortran 4.6 (see ISSM_DIR/externalpackages/gfortran) is necessary for ISSM compilation.
# On OSX 10.6, this recommended version gets installed in /usr/local/gfortran 
export CC=/usr/local/gfortran/bin/gcc
export CXX=/usr/local/gfortran/bin/g++

if [[ $install == "1" ]];then 

	#download numpy first
	git clone https://github.com/numpy/numpy.git

	#install numpy
	cd numpy
	python setup.py build
	python setup.py install
	cd ..
	${PYTHON} -c "import numpy; print 'Installed NumPy', numpy.__version__"
	${PYTHON} -c "import numpy; numpy.test()"
	
elif [[ $install == "2" ]];then 
	
	#download scipy
	git clone https://github.com/scipy/scipy.git

	#install scipy
	cd scipy
	python setup.py build
	python setup.py install
	cd ..
	${PYTHON} -c "import scipy; print 'Installed SciPy', scipy.__version__"
	${PYTHON} -c "import scipy; scipy.test()"

elif [[ $install == "3" ]];then 
	rm -rf numpy scipy
else 
	echo "Choice not covered"
fi
