/*\file BamgTriangulate.c
 *\brief: bamg module.
 */
#include "./BamgTriangulate.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input: */
	double* x=NULL;
	double* y=NULL;
	int     x_cols;
	int     y_rows,y_cols;
	int nods;

	/*Output*/
	int* index=NULL;
	int  nels;

	/*Intermediary*/
	int verbose=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgTriangulateUsage);

	/*Input datasets: */
	if (verbose) _printLine_("Fetching inputs");
	FetchData(&x,&nods,&x_cols,XHANDLE);
	FetchData(&y,&y_rows,&y_cols,YHANDLE);

	/*Check inputs*/
	if(y_rows!=nods)         _error2_("x and y do not have the same length");
	if(x_cols>1 || y_cols>1) _error2_("x and y should have only one column");
	if(nods<3)               _error2_("At least 3 points are required");

	/* Run core computations: */
	if (verbose) _printLine_("Call core");
	BamgTriangulatex(&index,&nels,x,y,nods);

	/*Write output*/
	WriteData(INDEX,index,nels,3);

	/*end module: */
	MODULEEND();
}

void BamgTriangulateUsage(void)
{
	_pprintString_("BAMGTRIANGULATE - Delaunay Triangulation of a list of points");
	_pprintLine_("");
	_pprintLine_("   Usage:");
	_pprintLine_("      index=BamgTriangulate(x,y);");
	_pprintLine_("      index: index of the triangulation");
	_pprintLine_("      x,y: coordinates of the nodes");
	_pprintLine_("");
}
